/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.trafficmanager.fluent.models.EndpointInner;
import com.azure.resourcemanager.trafficmanager.models.DnsConfig;
import com.azure.resourcemanager.trafficmanager.models.MonitorConfig;
import com.azure.resourcemanager.trafficmanager.models.ProfileStatus;
import com.azure.resourcemanager.trafficmanager.models.TrafficRoutingMethod;
import com.azure.resourcemanager.trafficmanager.models.TrafficViewEnrollmentStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ProfileInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ProfileInner.class);
    @JsonProperty(value="properties.profileStatus")
    private ProfileStatus profileStatus;
    @JsonProperty(value="properties.trafficRoutingMethod")
    private TrafficRoutingMethod trafficRoutingMethod;
    @JsonProperty(value="properties.dnsConfig")
    private DnsConfig dnsConfig;
    @JsonProperty(value="properties.monitorConfig")
    private MonitorConfig monitorConfig;
    @JsonProperty(value="properties.endpoints")
    private List<EndpointInner> endpoints;
    @JsonProperty(value="properties.trafficViewEnrollmentStatus")
    private TrafficViewEnrollmentStatus trafficViewEnrollmentStatus;
    @JsonProperty(value="properties.maxReturn")
    private Long maxReturn;

    public ProfileStatus profileStatus() {
        return this.profileStatus;
    }

    public ProfileInner withProfileStatus(ProfileStatus profileStatus) {
        this.profileStatus = profileStatus;
        return this;
    }

    public TrafficRoutingMethod trafficRoutingMethod() {
        return this.trafficRoutingMethod;
    }

    public ProfileInner withTrafficRoutingMethod(TrafficRoutingMethod trafficRoutingMethod) {
        this.trafficRoutingMethod = trafficRoutingMethod;
        return this;
    }

    public DnsConfig dnsConfig() {
        return this.dnsConfig;
    }

    public ProfileInner withDnsConfig(DnsConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
        return this;
    }

    public MonitorConfig monitorConfig() {
        return this.monitorConfig;
    }

    public ProfileInner withMonitorConfig(MonitorConfig monitorConfig) {
        this.monitorConfig = monitorConfig;
        return this;
    }

    public List<EndpointInner> endpoints() {
        return this.endpoints;
    }

    public ProfileInner withEndpoints(List<EndpointInner> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public TrafficViewEnrollmentStatus trafficViewEnrollmentStatus() {
        return this.trafficViewEnrollmentStatus;
    }

    public ProfileInner withTrafficViewEnrollmentStatus(TrafficViewEnrollmentStatus trafficViewEnrollmentStatus) {
        this.trafficViewEnrollmentStatus = trafficViewEnrollmentStatus;
        return this;
    }

    public Long maxReturn() {
        return this.maxReturn;
    }

    public ProfileInner withMaxReturn(Long maxReturn) {
        this.maxReturn = maxReturn;
        return this;
    }

    public void validate() {
        if (this.dnsConfig() != null) {
            this.dnsConfig().validate();
        }
        if (this.monitorConfig() != null) {
            this.monitorConfig().validate();
        }
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
    }
}

