/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.fluent.models.OperationProperties;
import com.azure.resourcemanager.storage.models.OperationDisplay;
import com.azure.resourcemanager.storage.models.ServiceSpecification;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class OperationInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OperationInner.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="display")
    private OperationDisplay display;
    @JsonProperty(value="origin")
    private String origin;
    @JsonProperty(value="properties")
    private OperationProperties innerOperationProperties;

    public String name() {
        return this.name;
    }

    public OperationInner withName(String name) {
        this.name = name;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public OperationInner withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public OperationInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    private OperationProperties innerOperationProperties() {
        return this.innerOperationProperties;
    }

    public ServiceSpecification serviceSpecification() {
        return this.innerOperationProperties() == null ? null : this.innerOperationProperties().serviceSpecification();
    }

    public OperationInner withServiceSpecification(ServiceSpecification serviceSpecification) {
        if (this.innerOperationProperties() == null) {
            this.innerOperationProperties = new OperationProperties();
        }
        this.innerOperationProperties().withServiceSpecification(serviceSpecification);
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
        if (this.innerOperationProperties() != null) {
            this.innerOperationProperties().validate();
        }
    }
}

